/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Ftable
extends Component
implements MouseMotionListener,
MouseListener {
    public static final String versionstring = "v0.05";
    FtableRenderer Render;
    FcellFocus focuslistener;
    byte gridType = (byte)2;
    int gridwidth = 2;
    int rowmax;
    int colmax;
    int[] rowpos;
    int[] colpos;
    int cachedwidth;
    int cachedheight;
    int defaultcolwidth = 40;
    int defaultrowheight = 20;
    boolean drag_on = false;
    int lastmousex;
    int lastmousey;
    int focuscellcol;
    int focuscellrow;

    public void repaint() {
        super.repaint();
    }

    public Ftable(FtableRenderer ftableRenderer) {
        this.Render = ftableRenderer;
        this.rowpos = new int[50];
        this.colpos = new int[50];
        this.rowpos[0] = 0;
        this.colpos[0] = 0;
        this.rowpos[1] = this.defaultrowheight;
        this.colpos[1] = this.defaultcolwidth;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setMax(int n, int n2) {
        int[] nArray;
        int n3;
        ++n2;
        if (++n > this.rowpos.length) {
            n3 = n / 50;
            nArray = new int[(n3 *= 50) + 2];
            System.arraycopy(this.rowpos, 0, nArray, 0, this.rowmax + 2);
            this.rowpos = nArray;
        }
        if (n2 > this.colpos.length) {
            n3 = n2 / 50;
            nArray = new int[(n3 *= 50) + 2];
            System.arraycopy(this.colpos, 0, nArray, 0, this.colmax + 2);
            this.colpos = nArray;
        }
        n3 = this.rowmax + 2;
        while (n3 <= n) {
            this.rowpos[n3] = this.rowpos[n3 - 1] + this.defaultrowheight + this.gridwidth;
            ++n3;
        }
        int n4 = this.colmax + 2;
        while (n4 <= n2) {
            this.colpos[n4] = this.colpos[n4 - 1] + this.defaultcolwidth + this.gridwidth;
            ++n4;
        }
        this.rowmax = n - 1;
        this.colmax = n2 - 1;
        this.debug("Ftable: set row/col max to " + this.rowmax + "," + this.colmax);
    }

    public int getRowHeight(int n) {
        return this.rowpos[n + 1] - this.rowpos[n];
    }

    public int getColWidth(int n) {
        return this.colpos[n + 1] - this.colpos[n];
    }

    public int getDRowHeight() {
        return this.defaultrowheight;
    }

    public int getDColWidth() {
        return this.defaultcolwidth;
    }

    public int getNumRows() {
        return this.rowmax + 1;
    }

    public int getNumCols() {
        return this.colmax + 1;
    }

    int getRowPos(int n) {
        return this.rowpos[n];
    }

    int getColPos(int n) {
        return this.colpos[n];
    }

    public void setDRowHeight(int n) {
        this.defaultrowheight = n;
        if (this.rowmax == 0) {
            this.rowpos[1] = n;
        }
    }

    public void setDColWidth(int n) {
        this.defaultcolwidth = n;
        if (this.colmax == 0) {
            this.colpos[1] = n;
        }
    }

    public void setColWidth(int n, int n2) {
    }

    public void setRowHeight(int n, int n2) {
    }

    public void setFocusListener(FcellFocus fcellFocus) {
        this.focuslistener = fcellFocus;
    }

    void forceCellDraw(int n, int n2) {
        Graphics graphics = this.getGraphics();
        Point point = this.getLocation();
        int n3 = point.y;
        int n4 = point.x;
        int n5 = this.colpos[n2] - n4;
        int n6 = this.rowpos[n] - n3;
        graphics.translate(n5, n6);
        this.Render.drawCell(graphics, n, n2);
        graphics.translate(-n5, -n6);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        FcellFocus fcellFocus = this.focuslistener;
        if (fcellFocus == null) {
            return;
        }
        Point point = this.getLocation();
        int n = point.y;
        int n2 = point.x;
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        Point point2 = new Point(n3 += n2, n4 += n);
        this.makeCellFromPixel(point2);
        int n5 = point2.x;
        int n6 = point2.y;
        point2 = null;
        if (this.focuscellcol != n5 || this.focuscellrow != n6) {
            if (this.focuscellrow <= this.rowmax && this.focuscellcol <= this.colmax) {
                fcellFocus.cellFocusLost(this.focuscellrow, this.focuscellcol);
            }
            if (n5 <= this.colmax && n6 <= this.rowmax) {
                fcellFocus.cellFocusGained(n6, n5);
            }
        }
        this.focuscellcol = n5;
        this.focuscellrow = n6;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastmousex = mouseEvent.getX();
        this.lastmousey = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.drag_on) {
            this.debug("need to handle drag-finish now");
        }
        this.drag_on = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drag_on = true;
    }

    void drawGrid(Graphics graphics) {
        this.drawGrid(graphics, 0, 0);
    }

    void drawGrid(Graphics graphics, int n, int n2) {
        switch (this.gridType) {
            case 0: {
                return;
            }
            case 1: {
                this.drawPlainGrid(graphics, n, n2);
                return;
            }
            case 2: {
                this.draw3dGrid(graphics, n, n2);
                return;
            }
        }
    }

    void drawPlainGrid(Graphics graphics, int n, int n2) {
        int n3;
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = n;
        int n7 = n2;
        Point point = this.getLocation();
        int n8 = point.y;
        int n9 = point.x;
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = this.colpos[this.colmax] + n9;
        if (n12 > n4) {
            n12 = n4;
        }
        if ((n3 = this.rowpos[this.rowmax] + n8) > n5) {
            n3 = n5;
        }
        int n13 = 0;
        int n14 = 0;
        graphics.setColor(Color.black);
        while (n13 < n4) {
            n13 = this.colpos[n7] + n9;
            graphics.drawLine(n13, n11, n13, n3);
            if (++n7 > this.colmax) break;
        }
        while (n14 < n5) {
            n14 = this.rowpos[n6] + n8;
            graphics.drawLine(n10, n14, n12, n14);
            if (++n6 <= this.rowmax) continue;
            return;
        }
    }

    void draw3dGrid(Graphics graphics, int n, int n2) {
        int n3;
        this.debug("draw3dgrid, for " + n + "," + n2);
        Rectangle rectangle = graphics.getClipBounds();
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y + rectangle.height;
        int n6 = n;
        int n7 = n2;
        Point point = this.getLocation();
        int n8 = point.y;
        int n9 = point.x;
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = this.colpos[this.colmax] + n9;
        if (n12 > n4) {
            n12 = n4;
        }
        if ((n3 = this.rowpos[this.rowmax] + n8) > n5) {
            n3 = n5;
        }
        int n13 = 0;
        int n14 = 0;
        graphics.setColor(Color.white);
        while (n13 < n4) {
            n13 = this.colpos[n7] + n9;
            graphics.drawLine(n13, n11, n13, n3);
            if (++n7 > this.colmax) break;
        }
        while (n14 < n5) {
            n14 = this.rowpos[n6] + n8;
            graphics.drawLine(n10, n14, n12, n14);
            if (++n6 > this.rowmax) break;
        }
        n13 = 0;
        n14 = 0;
        n6 = n;
        n7 = n2;
        graphics.setColor(Color.black);
        while (n13 < n4) {
            n13 = this.colpos[n7] + n9 + 1;
            graphics.drawLine(n13, n11, n13, n3);
            if (++n7 > this.colmax) break;
        }
        while (n14 < n5) {
            n14 = this.rowpos[n6] + n8 + 1;
            graphics.drawLine(n10, n14, n12, n14);
            if (++n6 <= this.rowmax) continue;
            return;
        }
    }

    void makeCellFromPixel(Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= this.colmax) {
            if (n < this.colpos[n4 + 1]) break;
            ++n4;
        }
        while (n3 <= this.rowmax) {
            if (n2 < this.rowpos[n3 + 1]) break;
            ++n3;
        }
        if (n4 > this.colmax) {
            n4 = -1;
        }
        if (n3 > this.rowmax) {
            n3 = -1;
        }
        point.x = n4;
        point.y = n3;
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Point point = this.getLocation();
        int n = point.y;
        int n2 = point.x;
        this.debug("Ftable.paint.gc" + rectangle);
        Point point2 = new Point();
        point2.x = rectangle.x - point.x;
        point2.y = rectangle.y - point.y;
        this.makeCellFromPixel(point2);
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = point2.y;
        int n6 = point2.x;
        point2 = null;
        if (n5 == -1) {
            this.debug(rectangle.toString());
            return;
        }
        this.drawGrid(graphics, n5, n6);
        while (n5 < this.rowmax && this.rowpos[n5] + n < n4) {
            int n7 = n6;
            while (n7 < this.colmax && this.colpos[n7] + n2 < n3) {
                int n8 = this.colpos[n7] + n2 + this.gridwidth;
                int n9 = this.rowpos[n5] + n + this.gridwidth;
                int n10 = this.colpos[n5 + 1] - this.colpos[n5] - this.gridwidth;
                int n11 = this.rowpos[n7 + 1] - this.rowpos[n7] - this.gridwidth;
                if (n10 > n3) {
                    n10 = n3;
                }
                if (n11 > n4) {
                    n11 = n4;
                }
                graphics.translate(n8, n9);
                graphics.setClip(0, 0, n10, n11);
                this.Render.drawCell(graphics, n5, n7);
                graphics.translate(-n8, -n9);
                ++n7;
            }
            ++n5;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        dimension.width = this.colpos[this.colmax] + this.gridwidth;
        dimension.height = this.rowpos[this.rowmax] + this.gridwidth;
        return dimension;
    }

    void debug(String string) {
        System.out.println(string);
    }
}

