/*
 * Decompiled with CFR 0.152.
 */
package com.bolthole;

import com.bolthole.constraints;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

public class jlayout {
    public static final int TileLeftOf = 1;
    public static final int TileUpOf = 1;
    public static final int AlignLeft = 2;
    public static final int AlignUp = 2;
    public static final int AlignInsideLeft = 3;
    public static final int AlignInsideUp = 3;
    public static final int Center = 10;
    public static final int TileRightOf = 11;
    public static final int TileDownOf = 11;
    public static final int AlignRight = 12;
    public static final int AlignDown = 12;
    public static final int AlignInsideRight = 13;
    public static final int AlignInsideDown = 13;
    Vector objectlist = new Vector();
    Vector locationlist = new Vector();
    Vector sizelist = new Vector();
    Vector constraintslist = new Vector();
    int border = 5;
    boolean debug_flag = false;

    boolean AlignUpDown(constraints constraints2, Point point, Dimension dimension) {
        int n;
        int n2 = -1;
        Object object = constraints2.UpDownRef;
        if (object == null) {
            this.debug("ERROR: null obj for alignUpDown");
            return false;
        }
        n2 = this.objectlist.indexOf(object);
        if (n2 == -1) {
            this.debug("ERROR: non-managed obj for alignUpDown: " + object);
            return false;
        }
        switch (constraints2.UpDownStyle) {
            case 0: {
                return false;
            }
            case 10: {
                int n3 = dimension.height >> 1;
                int n4 = this.getpoint((int)n2).y;
                n = (n4 += this.getsize((int)n2).height >> 1) - n3;
                break;
            }
            case 1: {
                n = this.getpoint((int)n2).y;
                n -= dimension.height + this.border;
                break;
            }
            case 11: {
                n = this.getpoint((int)n2).y;
                n += this.getsize((int)n2).height + this.border;
                break;
            }
            case 2: {
                n = this.getpoint((int)n2).y;
                break;
            }
            case 12: {
                n = this.getpoint((int)n2).y;
                n += this.getsize((int)n2).height;
                n -= dimension.height;
                break;
            }
            default: {
                this.debug("ERROR: unknown case for AlignUpDown()");
                return false;
            }
        }
        if (n == point.y) {
            return false;
        }
        point.y = n;
        return true;
    }

    boolean AlignXY(constraints constraints2, Point point, Dimension dimension) {
        int n;
        int n2 = -1;
        Object object = constraints2.XYRef;
        if (object == null) {
            this.debug("ERROR: null obj for alignXY");
            return false;
        }
        n2 = this.objectlist.indexOf(object);
        if (n2 == -1) {
            this.debug("ERROR: non-managed obj for alignXY: " + object);
            return false;
        }
        switch (constraints2.XYStyle) {
            case 0: {
                return false;
            }
            case 10: {
                int n3 = dimension.width >> 1;
                int n4 = this.getpoint((int)n2).x;
                n = (n4 += this.getsize((int)n2).width >> 1) - n3;
                break;
            }
            case 1: {
                n = this.getpoint((int)n2).x;
                n -= dimension.width + this.border;
                break;
            }
            case 11: {
                n = this.getpoint((int)n2).x;
                n += this.getsize((int)n2).width + this.border;
                break;
            }
            case 2: {
                n = this.getpoint((int)n2).x;
                break;
            }
            case 12: {
                n = this.getpoint((int)n2).x;
                n += this.getsize((int)n2).width;
                n -= dimension.width;
                break;
            }
            default: {
                this.debug("ERROR: unknown case for AlignXY()");
                return false;
            }
        }
        if (n == point.x) {
            return false;
        }
        point.x = n;
        return true;
    }

    public void addObject(Object object) {
        this.addObject(object, 0, 0, 0, 0);
    }

    public void addObject(Object object, int n, int n2, int n3, int n4) {
        if (object == null) {
            return;
        }
        if (this.objectlist.contains(object)) {
            return;
        }
        this.objectlist.addElement(object);
        this.locationlist.addElement(new Point(n, n2));
        this.sizelist.addElement(new Dimension(n3, n4));
        this.constraintslist.addElement(null);
        this.debug("jlayout: added object(" + this.getsize(this.locationlist.size() - 1) + ")");
    }

    void debug(String string) {
        if (!this.debug_flag) {
            return;
        }
        System.out.println(string);
    }

    public Dimension getBoundingDimension() {
        int n = 0;
        int n2 = 0;
        Vector vector = this.objectlist;
        synchronized (vector) {
            int n3 = this.objectlist.size();
            int n4 = 0;
            while (n4 < n3) {
                Point point;
                Dimension dimension = this.getsize(n4);
                if (dimension != null && (point = this.getpoint(n4)) != null) {
                    int n5 = point.x + dimension.width;
                    int n6 = point.y + dimension.height;
                    if (n5 > n) {
                        n = n5;
                    }
                    if (n6 > n2) {
                        n2 = n6;
                    }
                }
                ++n4;
            }
        }
        return new Dimension(n, n2);
    }

    public Dimension getDimension(Object object) {
        int n = this.objectlist.indexOf(object);
        if (n == -1) {
            return null;
        }
        return (Dimension)this.sizelist.elementAt(n);
    }

    public Point getLocation(Object object) {
        int n = this.objectlist.indexOf(object);
        if (n == -1) {
            return null;
        }
        return (Point)this.locationlist.elementAt(n);
    }

    Object getobject(int n) {
        return this.objectlist.elementAt(n);
    }

    int getobjectindex(Object object) {
        return this.objectlist.indexOf(object);
    }

    Point getpoint(int n) {
        return (Point)this.locationlist.elementAt(n);
    }

    Dimension getsize(int n) {
        return (Dimension)this.sizelist.elementAt(n);
    }

    public void layoutAll() {
        Vector vector = this.objectlist;
        synchronized (vector) {
            this.sweepObjs();
        }
    }

    public void removeObject(Object object) {
        Vector vector = this.objectlist;
        synchronized (vector) {
            int n = this.objectlist.indexOf(object);
            if (n == -1) {
                Object var3_4 = null;
                return;
            }
            this.objectlist.removeElementAt(n);
            this.locationlist.removeElementAt(n);
            this.sizelist.removeElementAt(n);
            this.constraintslist.removeElementAt(n);
        }
    }

    public void setConstraints(Object object, int n, Object object2, int n2, Object object3) {
        int n3 = this.objectlist.indexOf(object);
        if (n3 == -1) {
            this.debug("Warning: attempt to set constraints for object we dont manage");
            return;
        }
        if (n3 >= this.constraintslist.size()) {
            return;
        }
        constraints constraints2 = (constraints)this.constraintslist.elementAt(n3);
        if (constraints2 == null) {
            constraints2 = new constraints();
        }
        constraints2.XYStyle = n;
        constraints2.XYRef = object2;
        constraints2.UpDownStyle = n2;
        constraints2.UpDownRef = object3;
        this.constraintslist.setElementAt(constraints2, n3);
    }

    public void setLocation(Object object, int n, int n2) {
        Object e;
        int n3 = this.objectlist.indexOf(object);
        if (n3 == -1) {
            return;
        }
        if (n3 >= this.locationlist.size()) {
            return;
        }
        if (this.debug_flag && (e = this.constraintslist.elementAt(n3)) != null) {
            this.debug("WARNING: ignoring setLocation on object with constraints");
        }
        Point point = this.getpoint(n3);
        point.x = n;
        point.y = n2;
    }

    public void setSize(Object object, int n, int n2) {
        int n3 = this.objectlist.indexOf(object);
        if (n3 == -1) {
            this.debug("WARNING: ignoring setSize() for object we dont manage");
            return;
        }
        if (n3 >= this.sizelist.size()) {
            return;
        }
        Dimension dimension = this.getsize(n3);
        dimension.width = n;
        dimension.height = n2;
    }

    public void setSpacing(int n) {
        this.border = n;
    }

    void setsize(int n, Dimension dimension) {
        this.sizelist.setElementAt(dimension, n);
    }

    boolean sweepObjs() {
        int n = this.objectlist.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Object e = this.objectlist.elementAt(n2);
            constraints constraints2 = (constraints)this.constraintslist.elementAt(n2);
            if (constraints2 == null) {
                this.debug(" Debug: absolute positioning only for " + e);
                this.debug("     " + this.getpoint(n2) + "  " + this.getsize(n2));
            } else {
                Dimension dimension;
                Point point = this.getpoint(n2);
                if (this.AlignXY(constraints2, point, dimension = this.getsize(n2))) {
                    bl = true;
                }
                if (this.AlignUpDown(constraints2, point, dimension)) {
                    bl = true;
                }
                if (bl) {
                    this.debug("new coords set for object " + e);
                    this.debug("  new loc supposedly " + point);
                }
            }
            ++n2;
        }
        return bl;
    }
}

