/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class utfconvert {
    static String in_enc = "UTF8";
    static String out_enc = "EUCJIS";
    static boolean verbose = false;

    public static void usage() {
        System.out.println("utfconvert - by Philip Brown");
        System.out.println("http://www.bolthole.com/java/");
        System.out.println("Converts character encoding on input to new encoding on output");
        System.out.println("Usage: ");
        System.out.println("  utfconvert [-in ENCTYPE] [-out ENCTYPE]");
        System.out.println("  (defaults to   -in " + in_enc + " -out " + out_enc);
    }

    public static void parse_args(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-in")) {
                in_enc = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-out")) {
                out_enc = stringArray[n + 1];
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-v")) {
                verbose = true;
                ++n;
                continue;
            }
            utfconvert.usage();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        utfconvert.parse_args(stringArray);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in, in_enc);
            bufferedReader = new BufferedReader(inputStreamReader);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, out_enc);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            if (verbose) {
                System.err.println("instream encoding expected: " + inputStreamReader.getEncoding());
                System.err.println("outstream encoding set to: " + outputStreamWriter.getEncoding());
            }
            String string = null;
            string = bufferedReader.readLine();
            while (string != null) {
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
                string = bufferedReader.readLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

